<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE COMPRA</h4>
           
            
            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la compra :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->usuario->nombres))); ?> <?php echo e(ucwords(mb_strtolower($data->usuario->apellidos))); ?> (<?php echo e($data->usuario->username); ?>)</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la compra :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->created_at))); ?></div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  four wide computer column message_header">Almacen de Destino :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column"><?php echo e(ucwords(mb_strtolower($data->local->nombre))); ?> (<?php echo e(ucwords(mb_strtolower($data->local->direccion))); ?>)</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Nombre de Proveedor :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column"><a href="<?php echo e(url('proveedor/editar/'.$data->id_proveedor)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($data->proveedor->nombre))); ?> (<?php echo e($data->proveedor->tipo_documento->nombre); ?> : <?php echo e($data->proveedor->numero_documento); ?>)</a></div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e(!is_null($data->tipo_comprobante) ? $data->tipo_comprobante : 'No especificado'); ?></div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Numero de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e(!is_null($data->numero_comprobante) ? $data->numero_comprobante : 'No especificado'); ?></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Compra :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e(!is_null($data->fecha_compra) ? $data->fecha_compra : 'No especificado'); ?></div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total de la Compra :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ <?php echo e($data->total_compra); ?></div>
                    </div>
                </div>
            </div>
            
            <?php if($data->tipo_compra == 'CREDITO'): ?>
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Compra :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">AL <?php echo e($data->tipo_compra); ?></div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha a pagar la deuda:</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->fecha_pago); ?></div>
                    </div>
                </div>
            </div>
            <?php endif; ?>


            
            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                        <th class="center aligned" data-tooltip="Cantidad comprada" data-position="top center" data-inverted="">Cant.</th>
                        <th class="center aligned" data-tooltip="Precio de compra" data-position="top center" data-inverted="">P. Compra</th>
                        <th class="center aligned">Subtotal</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">P. Venta</th>
                        <th class="center aligned">Ganancia</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php $__currentLoopData = $detalle_compra; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $compra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($compra->id_detalle_compra); ?>">
                        <td><a href="<?php echo e(url('producto/editar/'.$compra->id_producto)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($compra->producto->nombre))); ?> (<?php echo e($compra->producto->tipo_presentacion->nombre); ?>)</a></td>
                        <td><?php echo e($compra->producto->unidad_medida->nombre); ?></td>
                        <td><?php echo e($compra->cantidad); ?></td>
                        <td><?php echo e($compra->precio_compra_unitario); ?></td>
                        <td class="warning"><?php echo e($compra->precio_compra_total); ?></td>
                        <td><?php echo e($compra->precio_venta_unitario); ?></td>
                        <td><?php echo e($compra->utilidad); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
                
                <div class="ui small right floated red button btn_anular"><i class="times icon"></i>Anular compra</div>
                <div class="ui small right floated primary button btn_imprimir"><i class="print icon"></i>Imprimir</div>
                
            </div>  

        </div>
    </div>


 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/compra/detalles.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>