<?php


Route::get('/', function () { return redirect('/login'); });
Route::get('/login', 'Auth\LoginController@showLoginForm')->name('login');
Route::post('/loginme', 'Auth\LoginController@login')->name('loginme');
Route::post('/logout', 'Auth\LoginController@logout')->name('logout');

Route::get('/recovery', 'Auth\ForgotPasswordController@recovery')->name('recovery');
Route::post('/recoveryme', 'Auth\ForgotPasswordController@recoveryme')->name('recoveryme');

Route::get('/reset', 'Auth\ForgotPasswordController@reset')->name('reset');
Route::post('/resetme', 'Auth\ForgotPasswordController@resetme')->name('resetme');

Route::get('/password/{id}', 'Auth\ForgotPasswordController@password')->name('password');
Route::post('/passwordme', 'Auth\ForgotPasswordController@passwordme')->name('passwordme');

Route::get('/home', 'HomeController@index')->name('home');

Route::group(array('before' => 'auth', 'prefix' => 'home'),function() 
{
	Route::get('getVentas', 'HomeController@getVentas');
});

Route::group(array('before' => 'auth', 'prefix' => 'personal'),function() 
{
	Route::get('nuevo', 'UsuarioController@nuevo');
	Route::get('listar', 'UsuarioController@listar');
	Route::post('registrar', 'UsuarioController@registrar');
	Route::get('existeCampo', 'UsuarioController@existeCampo');
	Route::get('existeCampoEditar', 'UsuarioController@existeCampoEditar');
	Route::get('editar/{id}', 'UsuarioController@editar');
	Route::post('actualizar', 'UsuarioController@actualizar');
	Route::post('eliminar', 'UsuarioController@eliminar');
	Route::post('getById', 'UsuarioController@getById');
	Route::get('perfil/{username}', 'UsuarioController@perfil');
	Route::post('actualizarPassword', 'UsuarioController@actualizarPassword');
	Route::post('updateLocal', 'UsuarioController@updateLocal');
});


Route::group(array('before' => 'auth', 'prefix' => 'sucursal'),function() 
{
	Route::get('nuevo', 'LocalController@nuevo');
	Route::get('listar', 'LocalController@listar');
	Route::post('registrar', 'LocalController@registrar');
	Route::get('editar/{id}', 'LocalController@editar');
	Route::post('actualizar', 'LocalController@actualizar');
	Route::post('eliminar', 'LocalController@eliminar');
	Route::get('getAll', 'LocalController@getAll');
});

Route::group(array('before' => 'auth', 'prefix' => 'proveedor'),function() 
{
	Route::get('nuevo', 'ProveedorController@nuevo');
	Route::get('listar', 'ProveedorController@listar');
	Route::get('existeCampo', 'ProveedorController@existeCampo');
	Route::post('registrar', 'ProveedorController@registrar');
	Route::get('editar/{id}', 'ProveedorController@editar');
	Route::post('actualizar', 'ProveedorController@actualizar');
	Route::post('eliminar', 'ProveedorController@eliminar');
	Route::post('getById', 'ProveedorController@getById');
	Route::get('buscar', 'ProveedorController@buscar');
});

Route::group(array('before' => 'auth', 'prefix' => 'producto'),function() 
{
	Route::get('nuevo', 'ProductoController@nuevo');
	Route::get('listar', 'ProductoController@listar');
	Route::post('registrar', 'ProductoController@registrar');
	Route::post('registrar_venta', 'ProductoController@registrar_venta');
	Route::post('registrar_proforma', 'ProductoController@registrar_proforma');
	Route::post('registrar_delivery', 'ProductoController@registrar_delivery');
	Route::get('editar/{id}', 'ProductoController@editar');
	Route::post('actualizar', 'ProductoController@actualizar');
	Route::post('eliminar', 'ProductoController@eliminar');
	Route::post('getById', 'ProductoController@getById');
	Route::get('getById2', 'ProductoController@getById2');
	Route::get('getByNombre', 'ProductoController@getByNombre');
	Route::get('getByCodBarras', 'ProductoController@getByCodBarras');
	Route::get('buscar', 'ProductoController@buscar');
	Route::get('existeCampo', 'ProductoController@existeCampo');
	Route::get('existeCampoEditar', 'ProductoController@existeCampoEditar');
	Route::get('presentacion', 'ProductoController@crearPresentacion');
	Route::get('unidad', 'ProductoController@crearUnidad');
	Route::post('registrar_unidad', 'ProductoController@registrar_unidad');
	Route::post('registrar_presentacion', 'ProductoController@registrar_presentacion');

});

Route::group(array('before' => 'auth', 'prefix' => 'compra'),function() 
{
	Route::get('nuevo', 'CompraController@nuevo');
	Route::get('listar', 'CompraController@listar');
	Route::post('registrar', 'CompraController@registrar');
	Route::get('detalles/{id}', 'CompraController@detalles');
	Route::get('buscar', 'CompraController@buscar');
	Route::post('anular', 'CompraController@anular');
	Route::get('listar_anulados', 'CompraController@listar_anulados');
	Route::get('listar_deuda', 'CompraController@listar_deuda');
	Route::get('detalles_deuda/{id}', 'CompraController@detalles_deuda');
	Route::post('anular_deuda', 'CompraController@anular_deuda');
});

Route::group(array('before' => 'auth', 'prefix' => 'producto_local'),function() 
{
	Route::get('alertas', 'ProductoLocalController@alertas');
	Route::get('getAll', 'ProductoLocalController@getAll');
	Route::get('getById', 'ProductoLocalController@getById');
	Route::get('getByIdLocal', 'ProductoLocalController@getByIdLocal');
	Route::get('getAllLocal', 'ProductoLocalController@getAllLocal');
	Route::get('getByCodBarras', 'ProductoLocalController@getByCodBarras');
	Route::get('getByNombre', 'ProductoLocalController@getByNombre');
	Route::get('getByNombreLocal', 'ProductoLocalController@getByNombreLocal');
	Route::get('listar', 'ProductoLocalController@listar');
	Route::get('listar_local/{id}', 'ProductoLocalController@listar_local');
});

Route::group(array('before' => 'auth', 'prefix' => 'retiro'),function() 
{
	Route::get('listar', 'RetiroController@listar');
	Route::get('nuevo', 'RetiroController@nuevo');
	Route::post('registrar', 'RetiroController@registrar');
	Route::get('detalles/{id}', 'RetiroController@detalles');
});
	

Route::group(array('before' => 'auth', 'prefix' => 'cliente'),function() 
{
	Route::get('nuevo', 'ClienteController@nuevo');
	Route::get('listar', 'ClienteController@listar');
	Route::get('existeCampo', 'ClienteController@existeCampo');
	Route::post('registrar', 'ClienteController@registrar');
	Route::get('editar/{id}', 'ClienteController@editar');
	Route::post('actualizar', 'ClienteController@actualizar');
	Route::post('canjear_puntos', 'ClienteController@canjear_puntos');
	Route::post('eliminar', 'ClienteController@eliminar');
	Route::post('getById', 'ClienteController@getById');
	Route::get('buscar', 'ClienteController@buscar');
	Route::get('getByDocumento', 'ClienteController@getByDocumento');
	Route::get('getDniByApi', 'ClienteController@getDniByApi');
	Route::get('getRucByApi', 'ClienteController@getRucByApi');
	Route::get('getByNombre', 'ClienteController@getByNombre');
});

Route::group(array('before' => 'auth', 'prefix' => 'venta'),function() 
{
	Route::get('nuevo', 'VentaController@nuevo');
	Route::get('listar', 'VentaController@listar');
	Route::get('listar_anulados', 'VentaController@listar_anulados');
	Route::post('registrar', 'VentaController@registrar');
	Route::get('detalles/{id}', 'VentaController@detalles');
	Route::get('buscar', 'VentaController@buscar');
	Route::get('getCorrelativo', 'VentaController@getCorrelativo');
	Route::get('listar_deuda', 'VentaController@listar_deuda');
	Route::post('anular_deuda', 'VentaController@anular_deuda');
	Route::get('detalles_deuda/{id}', 'VentaController@detalles_deuda');
	Route::get('proforma_venta/{id}', 'VentaController@proforma_venta');
	Route::get('delivery_venta/{id}', 'VentaController@delivery_venta');
	Route::get('listar_anulados', 'VentaController@listar_anulados');
	Route::post('registrar_letra', 'VentaController@registrar_letra');
	Route::post('eliminar_letra', 'VentaController@eliminar_letra');
	Route::get('buscar_deuda', 'VentaController@buscar_deuda');
});

Route::group(array('before' => 'auth', 'prefix' => 'contingencia'),function() 
{
	Route::get('nuevo', 'ContingenciaController@nuevo');
	Route::get('listar', 'ContingenciaController@listar');
	Route::get('listar_anulados', 'ContingenciaController@listar_anulados');
	Route::post('registrar', 'ContingenciaController@registrar');
	Route::get('detalles/{id}', 'ContingenciaController@detalles');
	Route::get('buscar', 'ContingenciaController@buscar');
	Route::get('credito/{id}', 'ContingenciaController@nuevo_credito');
	Route::post('registrar_credito', 'ContingenciaController@registrar_credito');

});


Route::group(array('before' => 'auth', 'prefix' => 'empresa'),function() 
{
	Route::get('nuevo', 'EmpresaController@nuevo');
	Route::post('registrar', 'EmpresaController@registrar');
	Route::get('editar/{id}', 'EmpresaController@editar');
	Route::post('actualizar', 'EmpresaController@actualizar');
	Route::get('envios', 'EmpresaController@envios');
});

Route::group(array('before' => 'auth', 'prefix' => 'nota'),function() 
{
	Route::get('listar_credito', 'NotaController@listar_credito');
	Route::get('estado_credito/{id}', 'NotaController@estado_credito');
	Route::get('credito/{id}', 'NotaController@credito');
	Route::get('listar_debito', 'NotaController@listar_debito');
	Route::get('estado_debito/{id}', 'NotaController@estado_debito');
	Route::get('debito/{id}', 'NotaController@debito');
	Route::post('registrar_credito', 'NotaController@registrar_credito');
	Route::post('registrar_debito', 'NotaController@registrar_debito');
	Route::get('detalles/{id}', 'NotaController@detalles');
});

Route::group(array('before' => 'auth', 'prefix' => 'electronico'),function() 
{
	Route::get('listar_facturas', 'ElectronicoController@listar_facturas');
	Route::get('estado_facturas/{id}', 'ElectronicoController@estado_facturas');
	Route::get('detalles/{id}', 'ElectronicoController@detalles');
	Route::get('listar_boletas', 'ElectronicoController@listar_boletas');
	Route::get('estado_boletas/{id}', 'ElectronicoController@estado_boletas');
	Route::get('notas_credito', 'ElectronicoController@notas_credito');
	Route::get('notas_debito', 'ElectronicoController@notas_debito');
	Route::get('resumen_diario', 'ElectronicoController@resumen_diario');
});

Route::group(array('before' => 'auth', 'prefix' => 'resumen'),function() 
{
	Route::get('listar', 'ResumenController@listar');
	Route::get('detalles/{id}', 'ResumenController@detalles');
	Route::get('estado/{id}', 'ResumenController@estado');
	
});

Route::group(array('before' => 'auth', 'prefix' => 'xml'),function() 
{
	Route::get('crearLlaves', 'XmlController@crearLlaves');
	Route::get('crearComprobante/{id}', 'XmlController@crearComprobante');
	Route::get('crearContingencia/{id}', 'XmlController@crearContingencia');
	Route::get('crearNota/{id}', 'XmlController@crearNota');
	Route::get('crearBaja/{id}', 'XmlController@crearBaja');
	Route::get('enviarFacturas', 'XmlController@enviarFacturas');
	Route::get('enviarNotas', 'XmlController@enviarNotas');
	Route::get('enviarGuias', 'XmlController@enviarGuias');
	Route::get('enviarBajas', 'XmlController@enviarBajas');
	Route::get('enviarResumen', 'XmlController@enviarResumen');	
	Route::get('enviarResumenNota', 'XmlController@enviarResumenNota');
	Route::get('ticketResumen', 'XmlController@ticketResumen');
	Route::get('ticketBaja', 'XmlController@ticketBaja');
	Route::get('reenviarResumen', 'XmlController@reenviarResumen');	
	Route::get('reenviarNota', 'XmlController@reenviarNota');
	Route::get('reenviarFactura', 'XmlController@reenviarFactura');
	Route::get('reenviarGuia', 'XmlController@reenviarGuia');
	Route::get('reenviarBaja', 'XmlController@reenviarBaja');
	Route::get('cdrFactura', 'XmlController@cdrFactura');
	Route::get('cdrNota', 'XmlController@cdrNota');
	Route::get('cdrResumen', 'XmlController@cdrResumen');
	Route::get('cdrBaja', 'XmlController@cdrBaja');
	Route::get('reenviarContingencia', 'XmlController@reenviarContingencia');
	Route::get('cdrContingencia', 'XmlController@cdrContingencia');

	Route::get('productos', 'XmlController@productos');
	Route::get('igv', 'XmlController@igv');
	Route::get('productos/{query}', 'XmlController@buscarProductos');
	Route::get('envios', 'XmlController@envios');
});

Route::group(array('before' => 'auth', 'prefix' => 'traslado'),function() 
{
	Route::get('nuevo', 'TrasladoController@nuevo');
	Route::get('listar', 'TrasladoController@listar');
	Route::get('detalles/{id}', 'TrasladoController@detalles');
	Route::post('registrar', 'TrasladoController@registrar');
});

Route::group(array('before' => 'auth', 'prefix' => 'reporte'),function() 
{
	Route::get('comprobantes', 'ReporteController@comprobantes');
	Route::get('ventas', 'ReporteController@ventas');
	Route::get('compras', 'ReporteController@compras');
	Route::get('egresos', 'ReporteController@egresos');
	Route::get('usuarios', 'ReporteController@usuarios');
	Route::get('detalles/{id}', 'ReporteController@detalles');
	Route::get('productos_vendidos', 'ReporteController@productos_vendidos');
	Route::get('productos_comprados', 'ReporteController@productos_comprados');
	Route::get('productos_vencidos', 'ReporteController@productos_vencidos');
	Route::get('stock', 'ReporteController@stock');
	Route::get('guia', 'ReporteController@guia');
	Route::get('bajas', 'ReporteController@bajas');
	Route::get('pedidos', 'ReporteController@pedidos');
	Route::get('kardex', 'ReporteController@kardex');
	Route::get('deudores', 'ReporteController@deudores');
	Route::get('tipo_impuesto', 'ReporteController@tipo_impuesto');
	Route::get('delivery', 'ReporteController@delivery');
	Route::get('productos_personal', 'ReporteController@productos_personal');
	Route::get('productos_historial', 'ReporteController@productos_historial');
});

Route::group(array('before' => 'auth', 'prefix' => 'egreso'),function() 
{
	Route::get('nuevo', 'EgresoController@nuevo');
	Route::get('listar', 'EgresoController@listar');
	Route::get('detalles/{id}', 'EgresoController@detalles');
	Route::post('registrar', 'EgresoController@registrar');
	Route::post('anular', 'EgresoController@anular');
});

Route::group(array('before' => 'auth', 'prefix' => 'proforma'),function() 
{
	Route::get('nuevo', 'ProformaController@nuevo');
	Route::get('listar', 'ProformaController@listar');
	Route::get('listar_deuda', 'ProformaController@listar_deuda');
	Route::get('detalles/{id}', 'ProformaController@detalles');
	Route::get('detalles_deuda/{id}', 'ProformaController@detalles_deuda');
	Route::post('registrar', 'ProformaController@registrar');
	Route::get('buscar', 'ProformaController@buscar');
	Route::get('getProductosById', 'ProformaController@getProductosById');
	Route::post('registrar_letra', 'ProformaController@registrar_letra');
	Route::post('eliminar_letra', 'ProformaController@eliminar_letra');
	Route::post('anular_deuda', 'ProformaController@anular_deuda');
	Route::post('anular', 'ProformaController@anular');
	Route::post('agregar_item', 'ProformaController@agregar_item');
	Route::post('quitar_item', 'ProformaController@quitar_item');
	Route::get('buscar_deuda', 'ProformaController@buscar_deuda');
});

Route::group(array('before' => 'auth', 'prefix' => 'guia'),function() 
{
	Route::get('emitir', 'GuiaRemisionController@emitir');
	Route::get('nuevo/{id}', 'GuiaRemisionController@nuevo');
	Route::get('nuevo_libre', 'GuiaRemisionController@nuevo_libre');
	Route::get('listar', 'GuiaRemisionController@listar');
	Route::get('listar_guias', 'GuiaRemisionController@listar_guias');
	Route::get('detalles/{id}', 'GuiaRemisionController@detalles');
	Route::get('detalles_electronico/{id}', 'GuiaRemisionController@detalles_electronico');
	Route::post('registrar', 'GuiaRemisionController@registrar');
	Route::post('registrar_libre', 'GuiaRemisionController@registrar_libre');
	Route::get('buscar', 'GuiaRemisionController@buscar');
	Route::get('buscar_venta', 'GuiaRemisionController@buscar_venta');
	Route::post('anular', 'GuiaRemisionController@anular');
	Route::get('estado/{id}', 'GuiaRemisionController@estado');
	Route::get('getByNombre', 'GuiaRemisionController@getByNombre');
});


Route::group(array('before' => 'auth', 'prefix' => 'baja'),function() 
{
	Route::get('emitir/{id}', 'BajaController@emitir');
	Route::get('nuevo/{id}/{tipo}', 'BajaController@nuevo');
	Route::post('registrar', 'BajaController@registrar');
	Route::get('detalles/{id}', 'BajaController@detalles');
	Route::get('listar', 'BajaController@listar');
	Route::get('estado/{id}', 'BajaController@estado');

});


Route::group(array('before' => 'auth', 'prefix' => 'delivery'),function() 
{
	
	Route::get('listar', 'DeliveryController@listar');
	Route::get('estado_delivery/{id}', 'DeliveryController@estado_delivery');
	Route::get('buscar', 'DeliveryController@buscar');
	Route::get('detalles/{id}', 'DeliveryController@detalles');
	Route::post('anular', 'DeliveryController@anular');
	Route::post('agregar_item', 'DeliveryController@agregar_item');
	Route::post('quitar_item', 'DeliveryController@quitar_item');
	Route::get('getProductosById', 'DeliveryController@getProductosById');
	Route::post('entregar', 'DeliveryController@entregar');

	/*Route::get('listar_deuda', 'DeliveryController@listar_deuda');
	Route::get('nuevo', 'DeliveryController@nuevo');
	Route::get('detalles_deuda/{id}', 'DeliveryController@detalles_deuda');
	Route::post('registrar', 'DeliveryController@registrar');
	Route::get('buscar', 'DeliveryController@buscar');
	Route::get('getProductosById', 'DeliveryController@getProductosById');
	Route::post('registrar_letra', 'DeliveryController@registrar_letra');
	Route::post('eliminar_letra', 'DeliveryController@eliminar_letra');
	Route::post('anular_deuda', 'DeliveryController@anular_deuda');
	Route::post('anular', 'DeliveryController@anular');
	Route::post('agregar_item', 'DeliveryController@agregar_item');
	Route::post('quitar_item', 'DeliveryController@quitar_item');
	*/
});

Route::group(array('prefix' => 'api'),function() 
{
	Route::get('productos', 'ApiController@productos');
	Route::get('productos/{query}', 'ApiController@buscarProductos');
	Route::post('registrar', 'ApiController@registrar');
	Route::get('getById2/{query}', 'ApiController@getById2');
	Route::get('getById', 'ApiController@getById');
	Route::get('getDniByApi', 'ApiController@getDniByApi');
	Route::get('getRucByApi', 'ApiController@getRucByApi');
	Route::get('getLocal', 'ApiController@getLocal');
	Route::get('getEmpresa', 'ApiController@getEmpresa');
	Route::get('getByNombre', 'ApiController@getByNombre');
	Route::get('getProductos', 'ApiController@getProductos');
});