@extends('layout.main')
@section('content')
@if ($data)
    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE {{$data->tipo}}</h4>
            <input type="hidden" id="id_proforma" value="{{$data->id_proforma}}">

            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la proforma :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->usuario->nombres)) }} {{ ucwords(mb_strtolower($data->usuario->apellidos)) }} ({{ $data->usuario->username }})</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la proforma :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->created_at)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Tienda donde se realizó la proforma:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column">{{ ucwords(mb_strtolower($data->local->nombre)) }} ({{ ucwords(mb_strtolower($data->local->direccion)) }})</div>
                    </div> 
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->nombre }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">DNI / RUC de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->numero_documento }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ ucwords(mb_strtolower($data->direccion)) }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Observacion :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column">{{ $data->tipo }} N° {{ $data->id_proforma }} {{ $data->observacion!=null ? ' - '.ucwords(mb_strtolower($data->observacion)) : '' }}</div>
                    </div>
                </div> 
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Emision :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">{{ $data->fecha_emision }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column" style="color:red">S/ {{ $data->total }}</div>
                    </div>
                    @if($data->tipo == "PEDIDO" )
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto que dejo de adelanto :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->adelanto != null ? $data->adelanto : '0.00' }}</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Saldo pendiente por cobrar :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ {{ $data->saldo != null ? $data->saldo : '0.00' }}</div>
                    </div>
                    @endif
                </div>
            </div> 

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cant.</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned" data-tooltip="Monto de Descuento" data-position="top center" data-inverted="">Dscto S/</th>
                        <th class="center aligned">Subtotal</th>
                        <th class="center aligned">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($detalle_proforma as $venta)
                    <tr data-table="{{ $venta->id_detalle_proforma }}">
                        <td><a href="{{ url('producto/editar/'.$venta->id_producto) }}" title="Clic para ver informacion">{{ ucwords(mb_strtolower($venta->producto->nombre)) }} {{ $venta->producto->descripcion }}</a></td>
                        <td>{{ $venta->producto->unidad_medida->nombre }}</td>
                        <td>{{ $venta->cantidad }}</td>
                        <td>{{ $venta->precio }}</td>
                        <td>{{ $venta->descuento==0 ? $venta->descuento : '-'.$venta->descuento  }}</td>
                        <td class="warning">{{ $venta->subtotal }}</td>
                        <td>

                            @if ($loop->count > 1)

                                <div class="ui mini vertical animated red button button_delete_modal" title="Eliminar registro" data-id="{{ $venta->id_detalle_proforma }}">
                                <div class="hidden content">Eliminar</div>
                                <div class="visible content"><i class="trash alternate icon"></i></div>
                                </div>
                                
                            @endif
                            
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                &nbsp;&nbsp;<a href="#" class="btn_modal_producto">(+) Agregar </a>
                @if($data->tipo == "PEDIDO" && $data->adelanto != null)
                <a class="ui small right floated orange button" href="{{ url('proforma/detalles_deuda/'.$data->id_proforma) }}"><i class="check icon"></i>Detalle de Pagos</a> 
                @endif
                @if($data->tipo == "PEDIDO")
                    <div class="ui small right floated red button btn_anular"><i class="times icon"></i>Anular</div>
                @endif
                <div class="ui small right floated primary button btn_imprimir" data-id="{{ $data->id_proforma }}"><i class="print icon"></i>Imprimir Ticket</div>
                <div class="ui small right floated green button btn_imprimir_a4" data-id="{{ $data->id_proforma }}"><i class="print icon"></i>Imprimir A4</div> 
                <a class="ui small right floated violet button" href="{{ url('venta/proforma_venta/'.$data->id_proforma) }}"><i class=" sign dollar icon"></i>Emitir Comprobante</a> 
                
                {{-- <div class="ui small right floated green button btn_enviar"><i class="paper plane icon"></i>Enviar Correo</div> --}}
            </div>  

        </div>
    </div>


    <!--start update modal -->
    <div class="ui small basic modal" id="update_modal">
        <div class="ui icon header"><i class="paper plane icon"></i>Anular pedido</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere anular el pedido?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para anular compra"> <i class="checkmark icon"></i>Anular</div>
        </div>
    </div>
    <!--end update modal -->

    <!--start buscar producto modal -->
    <div class="ui standard large modal" id="buscar_producto_modal">
        <div class="header">Agregar Productos</div>
        <div class="scrolling content" style="height: 250px;">

            <form class="ui form" id="frmAgregar" autocomplete="off"> 
                <input type="hidden" name="id_proforma" value="{{$data->id_proforma}}">
                <div class="two fields">
                    <div class="three wide field">
                        <label>Buscar Producto : </label>
                    </div>
                    <div class="ten wide field">
                        <select class="ui search selection" name="id_prod">
                        </select>  
                    </div>
                </div> 
            
                <table class="ui celled table">
                    <thead>
                        <tr>
                            <th class="center aligned">Producto</th>
                            <th class="center aligned" data-tooltip="Cantidad a vender" data-position="top center" data-inverted="">Cantidad</th>
                            <th class="center aligned" data-tooltip="Precio de venta unitario" data-position="top center" data-inverted="">Precio S/</th>
                            <th class="center aligned" data-tooltip="Monto para descuento" data-position="top center" data-inverted="">Dscto S/</th>
                            <th class="center aligned">Subtotal S/</th>
                            <th class="center aligned">Acción</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>
                </table>
            </form>

        </div>
        <div class="actions" >
            <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <a href="#" class="ui left floated  btn_nuevo_producto" style="float: left; margin-top: 10px">(+) Crear Nuevo</a>
            <div class="ui labeled small input">
                <label class="ui brown label">TOTAL  S/</label>
                <input type="text" name="total_venta" id="total_venta" size="5" readonly style="width: 0%">
            </div> 
            <div class="ui right floated primary button btn_agregar"><i class="plus icon"></i>AGREGAR</div>
        </div>
    </div>
    <!--end buscar producto modal -->

    <!--start nuevo producto modal -->
    <div class="ui modal" id="nuevo_producto_modal">
        <div class="header">Registrar Nuevo </div>     
        <div class="content">
            <div class="ui disabled inverted dimmer" id="loader_producto">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmNuevoProducto" autocomplete="off">
                
                <input type="hidden" name="situacion_impuesto" value="AFECTO">
                <input type="hidden" name="tipo_impuesto" value="IGV">
                <input type="hidden" name="valor_impuesto" value="{{$empresa->valor_impuesto}}">
                <input type="hidden" name="tipo_producto" value="Generico">
                <input type="hidden" name="id_unidad_medida" value="1">
                <input type="hidden" name="id_tipo_presentacion" value="1">
                <input type="hidden" name="codigo_barras" value="">
                <input type="hidden" name="cantidad" value="1">

               
                <div class="two fields">
                    <div class="twelve wide field">
                        <label>Nombre del Concepto</label>
                        <div class="ui small input ">
                          <input type="text" name="nombre" maxlength="800" oninput="$.upperCase(this)">
                        </div>
                    </div>
                    <div class="four wide field">
                        <label>Monto</label>
                        <div class="ui labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="precio" maxlength="11">
                        </div>  
                    </div>
                </div>  

            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_producto"><i class="plus icon"></i>AGREGAR</div>
        </div>
    </div>
    <!--end nuevo producto  modal --> 

    <!--start register modal -->
    <div class="ui small basic modal" id="agregar_modal">
        <div class="ui icon header"><i class="circular inverted white dollar plus icon"></i>Agregar</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea agregar estos productos?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para agregar"> <i class="paper plane icon"></i>Agregar</div>
        </div>
    </div>
    <!--end register modal -->

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Eliminar Registro</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere eliminar este registro del sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Eliminar</div>
        </div>
    </div>
    <!--end delete modal -->

@else
    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            <h3 class="ui header black centered">No se puede realizar esta accion</h3>
        </div>
    </div>    
@endif

@stop

@section('scripts')
    <script src="{{ asset('js/proforma/detalles.js') }}"></script>
@stop


