@extends('layout.main')
@section('content')
    
    @if ($data)
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                
                <h4 class="ui dividing header teal centered">EDITAR DATOS DE PRODUCTO</h4>
                <br>

                <form class="ui form" id="frmEditar" autocomplete="off">
                    <input type="hidden" id="id_producto" name="id_producto" value="{{ $data->id_producto }}">
                    
                    <div class="field">
                        <div class="field">
                            <label>Nombre del producto</label>
                            <div class="ui small input ">
                              <input type="text" name="nombre" maxlength="800" oninput="$.upperCase(this)" value="{{ $data->nombre }}">
                            </div>
                        </div>
                    </div>                 
    
                    <div class="two fields">
                        <div class="field">
                            <label>Marca del producto</label>
                            <div class="ui small input ">
                              <input type="text" name="descripcion"  maxlength="200" oninput="$.upperCase(this)" value="{{ $data->descripcion }}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Código de Barras</label>
                            <div class="ui small input ">
                              <input type="text" name="codigo_barras"  maxlength="100" oninput="$.upperCase(this)" value="{{ $data->codigo_barras }}">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">


                        {{-- <div class="one wide field">
                            <select class="ui fluid small input dropdown" name="tipo_precio">
                                <option value="1"> S/ </option>
                                <option value="2"> %  </option>
                            </select>    
                        </div>

                        <div class="three wide field">
                            <div class="ui small input">
                                <input type="text" name="precio" maxlength="11">
                            </div> 
                        </div> --}}
                        <div class="one wide field">
                            <label>&nbsp;</label>
                            <div class="ui small input">
                                <select class="ui fluid small input dropdown" name="tipo_precio">
                                    <option value="1"> S/ </option>
                                    <option value="2"> %  </option>
                                </select> 
                            </div>  
                        </div>

                        <div class="three wide field">
                            <label>Precio de VENTA Unitario</label>
                            <div class="ui small input">
                                <input type="text" name="precio" value="{{ $data->precio }}" maxlength="11">
                            </div>  
                        </div>

                       

                        <div class="four wide field">
                            <label>Precio de Compra Unitario</label>
                            <div class="ui labeled small input">
                                <label class="ui label">S/</label>
                                <input type="text" name="precio_compra" value="{{ $data->precio_compra }}" maxlength="11">
                            </div>  
                        </div>


                        <div class="one wide field">
                            <label>Precio</label>
                            <div class="ui small input">
                                <select class="ui fluid small input dropdown" name="tipo_precio_2">
                                    <option value="1"> S/ </option>
                                    <option value="2"> %  </option>
                                </select> 
                            </div>  
                        </div>

                         <div class="three wide field">
                            <label>de venta por MAYOR</label>
                            <div class="ui small input">
                               
                                <input type="text" name="precio_mayorista" value="{{ $data->precio_mayorista }}" maxlength="11">
                            </div>  
                        </div>

                        <div class="four wide field">
                            <label>Fecha de Vencimiento</label>
                            <div class="ui small input">
                                <input type="text" class="fecha" name="fecha_vencimiento" value="{{ $data->fecha_vencimiento }}">
                            </div>  
                        </div>
                    </div> 

                    <div class="two fields">
                        <div class="field">
                            <label>Tipo de Presentación</label>
                            <select class="ui small search selection dropdown" name="id_tipo_presentacion">
                                @foreach($tipo_presentacion as $tipo)
                                    @if($tipo->id_tipo_presentacion == $data->id_tipo_presentacion)
                                        <option value="{{ $tipo->id_tipo_presentacion }}" selected> {{ $tipo->nombre }} </option>
                                    @else
                                        <option value="{{ $tipo->id_tipo_presentacion }}"> {{ $tipo->nombre }} </option>
                                    @endif
                                @endforeach
                            </select>  
                        </div>
                        <div class="field">
                            <label>Unidad de Medida</label>
                            <select class="ui small search selection dropdown" name="id_unidad_medida">
                                @foreach($unidad_medida as $unidad)
                                    @if($unidad->id_unidad_medida == $data->id_unidad_medida)
                                        <option value="{{$unidad->id_unidad_medida}}" selected>{{$unidad->nombre}} ({{$unidad->abreviatura}})</option>
                                    @else
                                        <option value="{{$unidad->id_unidad_medida}}">{{$unidad->nombre}} ({{$unidad->abreviatura}})</option>
                                    @endif
                                @endforeach
                            </select>  
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Situacion de Impuesto</label>
                            <select class="ui small selection dropdown" name="situacion_impuesto">
                                <option value="AFECTO" {{ $data->situacion_impuesto == "AFECTO" ? "selected" : ""}}>Afecto</option>
                                <option value="INAFECTO" {{ $data->situacion_impuesto == "INAFECTO" ? "selected" : ""}}>Inafecto</option>
                                <option value="EXONERADO" {{ $data->situacion_impuesto == "EXONERADO" ? "selected" : ""}}>Exonerado</option>
                            </select>  
                        </div>
                        
                        <div class="field">
                            <label>Tipo de Producto</label>
                            <select class="ui small input dropdown" name="tipo_producto">
                                <option value="Generico" {{ $data->tipo_producto == "Generico" ? "selected" : ""}}>Generico</option>
                                <option value="Comercial" {{ $data->tipo_producto == "Comercial" ? "selected" : ""}}>Comercial</option>
                            </select>  
                        </div>

                    </div> 

                    <div class="two fields">
                         <div class=" field">
                            <label>Tipo de Impuesto</label>
                            <select class="ui small selection dropdown" name="tipo_impuesto">
                                <option value="IGV">IGV</option>
                                {{-- <option value="ISC">ISC</option> --}}
                            </select>  
                        </div>
                        <div class="field">
                            <label>Valor de Impuesto</label>
                            <div class="ui right labeled small input">
                                <input type="text" name="valor_impuesto" value="{{ $data->valor_impuesto }}" readonly maxlength="8">
                                <label class="ui label">%</label>
                            </div>  
                        </div>
                    </div>

                    <div class="two fields">

                        @if (Auth::guard("usuario")->user()->id_rol == 1 || Auth::guard("usuario")->user()->id_rol == 4)


                        <div class="four wide field">
                            <label>Stock Actual</label>
                            <div class="ui small input">
                                <input type="text" name="cantidad" value="{{ $cantidad ? ($cantidad->stock > 1000000 ? $cantidad->stock - 1000000 : 0) : 0}}" maxlength="50">
                            </div>  
                        </div>

                        <div class="four wide field">
                            <label>Cantidad para Alertas</label>
                            <div class="ui small input">
                                <input type="text" name="alerta" value="{{ $cantidad ? $cantidad->stock_alerta : 0}}" maxlength="5">
                            </div>  
                        </div>
                        @else
                            <input type="hidden" name="cantidad" value="{{ $cantidad ? ($cantidad->stock > 1000000 ? $cantidad->stock - 1000000 : 0) : 0}}" >
                            <input type="hidden" name="alerta" value="{{ $cantidad ? $cantidad->stock_alerta : 0}}" >
                        @endif
                        
                        <div class=" field">
                            <label>Lote / Serie</label>
                            <div class="ui small input">
                                <input type="text" name="lote" value="{{ $data->lote }}" maxlength="800">
                            </div>  
                        </div>
                    </div>  
                    
                    <div class="two fields">


                        <div class="six wide field">
                            <label>Imagen del producto</label>
                            <div class="ui action small input" id="cargar-imagen">
                                <input type="text" placeholder="Tamaño maximo de imagen 2MB" readonly>
                                <input type="file" name="imagen" id="imagen" multiple="" accept="image/x-png,image/gif,image/jpeg"/>
                              
                                <div class="ui icon button" title="Seleccione una imagen para el producto">
                                    <i class="attach icon"></i>
                                </div>
                            </div>  
                        </div>
                        
                        <div class="two wide field">
                            <label>&nbsp;</label>
                            <div class="ui fluid small green button btn_ver_imagen" title="Clic para ver lista de productos"><i class="search icon"></i>Ver Foto</div>
                        </div>

                        <div class=" field">
                            <label>Tiene ICBPER? (solo bolsas)</label>
                            <select class="ui small input dropdown" name="icbper">
                                <option value="0" {{ $data->icbper == "0" ? "selected" : ""}}>NO</option>
                                <option value="1" {{ $data->icbper == "1" ? "selected" : ""}}>SI</option>
                            </select> 
                        </div>
                    </div> 
              
                        
                    <div class="form_footer">
                        <a class="ui left floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>
                        <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR</div>
                    </div>    
                </form>

            </div>
        </div>

        <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
            </div>
        </div>
        <!--end update modal -->

        <!--start imagen modal -->
        <div class="ui standard mini modal" id="imagen_modal">
            <div class="header">Imagen del producto</div>
            <div class="scrolling content" >
                <img class="medium ui image" style="height: 300px; margin:auto;" id="img_producto" src="  {{ $data->url_imagen != null ? asset('img/productos/'.$data->url_imagen) : asset('img/productos/default.jpg') }}">
            </div>
            <div class="actions" >
                <div class="ui left floated red right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div> 
            </div>
        </div>
        <!--end imagen modal -->


    @else
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                <h3 class="ui header black centered">No se encuentra el registro que desea editar</h3>
            </div>
        </div>    
    @endif

@stop

@section('scripts')
    <script src="{{ asset('js/producto/editar.js') }}"></script>
@stop


