@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">SELECCIONE UNA VENTA PARA EMITIR SU GUIA DE REMISION</h4>
           
            <div class="ui equal width grid">
                <div class="row">
                    <div class="column">
                        <form id="frmBuscar" autocomplete="off" method="GET" action="{{ url('guia/buscar_venta') }}" >
                            <div class="ui action small input" >
                                  <input type="text" placeholder="Buscar..." name="search">
                                  <button type="submit" class="ui icon button " title="Clic para buscar"><i class="search icon"></i></button>
                            </div>
                        </form>
                    </div>
                    <div class="column export_files" style="text-align: right">
                        <a href="{{ url('guia/nuevo_libre' ) }}" class="ui right floated violet button"><i class="plus icon"></i>Emitir Nueva Guia</a>
                    </div> 
                </div>
            </div>

            <table class="ui celled striped table">
                <thead>
                    <tr>
                        <th class="head_table">N°</th>
                        <th class="head_table">Cliente</th>
                        <th class="head_table">Tipo</th>
                        <th class="head_table">Comprobante</th>
                        <th class="head_table">Fecha de Venta</th>
                        <th class="head_table">Total S/</th>
                        <th class="head_table">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php /**/ $i = $data->firstItem() /**/ ?>
                    @foreach ($data as $venta)
                    <tr data-table="{{ $venta->id_venta }}">
                        <td>{{ $i }}</td>
                        <td>{{ $venta->cliente->nombre }}</td>
                        <td>{{ $venta->tipo_comprobante->nombre }}</td>
                        <td>{{ $venta->nombre_comprobante }}</td>
                        <td>{{ $venta->created_at }}</td>
                        <td>{{ $venta->total_venta }}</td>
                        <td>    
                            <?php /**/ $count = 0/**/ ?>
                            @foreach($guias as $guia)
                                @if($venta->id_venta == $guia->id_venta)
                                    <?php /**/ $count++ /**/ ?>
                                    <?php /**/ $id_guia = $guia->id_guia_remision/**/ ?>
                                @endif
                            @endforeach 

                             @if($count > 0)
                                    <a class="ui mini vertical animated blue button" title="Ver informacion detallada" href="{{ url('guia/detalles/'.$id_guia ) }}">
                                        <div class="hidden content">Emitido</div>
                                        <div class="visible content"><i class="search icon"></i></div>
                                    </a>
                                @else
                                    <a class="ui mini vertical animated green button" title="Emitir guia para este registro" href="{{ url('guia/nuevo/'.$venta->id_venta) }}">
                                        <div class="hidden content">Emitir</div>
                                        <div class="visible content"><i class="check icon"></i></div>
                                    </a>
                                @endif                      
                        </td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">
                            @include('layout.includes.pagination')
                        </th>
                    </tr>
                </tfoot>
            </table>

        </div>
    </div>

@stop


