$(function () {

    $('#frmEditar').form({
    	keyboardShortcuts: false,
    	fields: {
	      	nombre: {
		        rules: [{ type : 'empty', prompt : 'Complete este campo'}]
		    },
		    numero_documento: {
		        rules: [
		        	{ type : 'empty', prompt : 'Complete este campo'},
		        	{ type : 'integer', prompt : 'Ingrese solo números'}
		        ]
		    },
		    id_tipo_documento: {
		        rules: [{ type : 'empty', prompt : 'Seleccione una opción'}]
		    },
		    telefono: {
		    	optional: true,
		        rules: [{ type : 'integer', prompt : 'Ingrese solo números'}]
		    },
		    email: {
		    	optional: true,
		        rules: [{ type : 'email', prompt : 'Ingrese un email válido'}]
		    },
    	},
    	inline : true,
    });

    $('[name="id_tipo_documento"]').change(function() {
	  	
	  	var option= $("option:selected", this).text();

	  	if (option == "RUC") {
	  		$('input[name="numero_documento"]').attr('maxlength', 11);
	  		$('#frmEditar').form('add rule', 'numero_documento', {
		        rules: [
		        	{ type : 'integer', prompt : 'Ingrese solo números'},
		        	{ type : 'exactLength[11]', prompt : 'El RUC debe tener {ruleValue} digitos'}
		        ]
		    });
	  	}
	  	if (option == "DNI") {
	  		$('input[name="numero_documento"]').attr('maxlength', 8);
	  		$('#frmEditar').form('add rule', 'numero_documento', {
		        rules: [
		        	{ type : 'integer', prompt : 'Ingrese solo números'},
		        	{ type : 'exactLength[8]', prompt : 'El DNI debe tener {ruleValue} digitos'}
		        ]
		    });
	  	}
	});

    $('.btn_guardar').on('click', function() {
		if ($('#frmEditar').form('is valid')) {
			$('#update_modal').modal({
  				closable: false,
		    	onApprove : function() {
		    		sendForm();
			    }
	  		}).modal('show'); 
		} else {
			$('#frmEditar').form('validate form');
		}
  	});

	function sendForm() {

	    var data = $('#frmEditar').serialize();

        $.requestApi('/proveedor/actualizar', data, 'POST', function (resolve) {
	        if (resolve) {
	            $.showMessages(resolve);
	        }
	    });
        
        return false;
	};

});
