'use strict';

/** @function
 * @name requestApi 
 * @description Función para hacer petición a la API
 * @param {string} uri uri de la petición
 * @param {Object} data JSON con datos a mandar
 * @param {function} success Se ejecuta cuando todo es correcto
 * @param {function} error Se ejecuta cuando ocurre un error
 * @param {boolean} lockAllScrren Especifica si se bloqueara la pantalla mientras se hace la peticion
 * @param {string} method POST - GET - PUT - PATCH - DELETE */
$.requestApi = function (uri, _data, _method, _success, lockScreen, _error) {

    $.ajax({
        url: APP_URL + uri,
        dataType: 'json',
        method: _method || "POST",
        headers: {
            "content-type": "application/x-www-form-urlencoded",
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            "cache-control": "no-cache"
        },
        data: _data,
        beforeSend: function () {
            if (!lockScreen) //poner 'true' para NO mostrar el lockScreen
                $('#ajax_loader').removeClass('disabled').addClass('active'); //loader start
        },
        success: _success || function (data, textStatus, xhr) {
            console.dir(data);
        },
        error: _error || function (xhr, textStatus, errorThrown) {
            $('#ajax_loader').removeClass('active').addClass('disabled'); //loader stop
            swal({title: "Error Interno!", text: "Por favor verifique que todo este correcto e intente de nuevo, si el error persiste contáctese con el administrador del sistema", icon: "error", button: "OK"});
        },
        complete: function (xhr) {
            $('#ajax_loader').removeClass('active').addClass('disabled'); //loader stop
        }
    });
}

/** @function
 * @name requestApi 
 * @description Función minimal para hacer petición a la API
 * @param {string} uri uri de la petición
 * @param {Object} data JSON con datos a mandar
 * @param {function} success Se ejecuta cuando todo es correcto
 * @param {function} error Se ejecuta cuando ocurre un error
 * @param {string} method POST - GET - PUT - PATCH - DELETE */
$._requestApi = function (uri, _data, _method, _success, _error) {
    $.ajax({
        url: APP_URL + uri,
        dataType: 'json',
        method: _method || "POST",
        headers: {
            "content-type": "application/x-www-form-urlencoded",
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            "cache-control": "no-cache"
        },
        data: _data,
        success: _success || function (data, textStatus, xhr) {
            console.dir(data);
        },
        error: _error || function (xhr, textStatus, errorThrown) {
            swal({title: "Error Interno!", text: "Por favor verifique que todo este correcto e intente de nuevo, si el error persiste contáctese con el administrador del sistema", icon: "error", button: "OK"});
        },
    });
}

/** @function
 * @name requestApi 
 * @description Función para hacer petición a la API
 * @param {string} uri uri de la petición
 * @param {Object} data JSON con datos a mandar
 * @param {function} success Se ejecuta cuando todo es correcto
 * @param {function} error Se ejecuta cuando ocurre un error
 * @param {boolean} lockAllScrren Especifica si se bloqueara la pantalla mientras se hace la peticion
 * @param {string} method POST - GET - PUT - PATCH - DELETE */
$.requestApiFile = function (uri, _data, _method, _success, lockScreen, _error) {

    $.ajax({
        url: APP_URL + uri,
        dataType: 'json',
        processData : false, 
        contentType: false, 
        method: _method || "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            "cache-control": "no-cache"
        },
        data: _data,
        beforeSend: function () {
            if (!lockScreen) //poner 'true' para NO mostrar el lockScreen
                $('#ajax_loader').removeClass('disabled').addClass('active'); //loader start
        },
        success: _success || function (data, textStatus, xhr) {
            console.dir(data);
        },
        error: _error || function (xhr, textStatus, errorThrown) {
            $('#ajax_loader').removeClass('active').addClass('disabled'); //loader stop
            swal({title: "Error Interno!", text: "Por favor verifique que todo este correcto e intente de nuevo, si el error persiste contáctese con el administrador del sistema", icon: "error", button: "OK"});
        },
        complete: function (xhr) {
            $('#ajax_loader').removeClass('active').addClass('disabled'); //loader stop
        }
    });
}


/** @function
 * @name showMessages 
 * @description Muestra un mensaje usando la librería sweetalert
 * @param {Object} JSON Un objeto JSON con 2 propiedades: 'messages' {Array[string]}, contiene los mensajes; 'type' {string}, tipo de mensaje [Correct, Error, Warning]
 */
$.showMessages = function (objectMessage, redirect = false, url) {
    if (objectMessage)
    {
        if (objectMessage.message === "success" ) {
            swal({title: "Correcto!", text: "La acción fue realizada con éxito", icon: "success", button: "OK"})
                .then(() => {redirect ? location.href = url : ''});
        }
        if (objectMessage.message === "error" ) {
            swal({title: "Algo salió mal :(", text: "Por favor verifique que todo este correcto e intente de nuevo", icon: "warning", button: "OK"});
        }
        else {
            return;
        }
    }
}

/** @function
 * @name showMessages 
 * @description Muestra un mensaje usando la librería sweetalert
 * @param {Object} JSON Un objeto JSON con 2 propiedades: 'messages' {Array[string]}, contiene los mensajes; 'type' {string}, tipo de mensaje [Correct, Error, Warning]
 */
$.showMessagesImprimir = function (objectMessage, url1, url2) {
    if (objectMessage)
    {
        if (objectMessage.message === "success" ) {
            swal({title: "Correcto!", text: "La acción se realizó con éxito", icon: "success", button: "IMPRIMIR"})
                .then(() => {var win = window.open(url2, '_blank'); win.focus(); location.href = url1; });
        }
        if (objectMessage.message === "error" ) {
            swal({title: "Algo salió mal :(", text: "Por favor verifique que todo este correcto e intente de nuevo", icon: "warning", button: "OK"});
        }
        else {
            return;
        }
    }
}

/** @function
 * @name showMessages 
 * @description Muestra un mensaje usando la librería sweetalert
 * @param {Object} JSON Un objeto JSON con 2 propiedades: 'messages' {Array[string]}, contiene los mensajes; 'type' {string}, tipo de mensaje [Correct, Error, Warning]
 */
$.showMessagesComment = function (objectMessage, redirect = false, url) {
    if (objectMessage)
    {
        if (objectMessage.message === "success" ) {
            swal({title: "Correcto!", text: "La acción fue realizada con éxito", icon: "success", button: "OK"})
                .then(() => {redirect ? location.href = url : ''});
        }
        if (objectMessage.message === "error" ) {
            swal({title: "Algo salió mal :(", text: objectMessage.comment , icon: "warning", button: "OK"});
        }
        else {
            return;
        }
    }
}
/**
 * Métodos con propositos definidos
 * @module Helpers  $.Helper
 */
$.Helper = new Object();

/** @function
 * @name clearFields
 * @description Limpia el contenido de input's y textarea's de un contenedor
 * @param {string} idContainer id del contenedor (incluir el #)
 * @param {Array} arrayExceptions id's de los campos a ignorar
 * @return {void} void
 */

$.Helper.clearFields = function (container, _arrayExceptions) {
    $(container).find('input[type="text"], input[type="email"], input[type="checkbox"], input[type="file"], input[type="password"], textarea').each(function (index, element) {
        if (Array.isArray(_arrayExceptions)) {
            if (!_arrayExceptions.some(function (_element) {
                return _element === $(element).attr('id');
            })) {
                $.Helper.clearContentField(element);
            }
        }
        else {
            $.Helper.clearContentField(element);
        }
    });
}

/** @function
 * @name clearContentField
 * @description Limpia el contenido de un input o textarea
 * @param {string} idField id del elemento (incluir #)
 * @return {void} void
 */
$.Helper.clearContentField = function (idField) {
    if ($(idField).attr('type') === "checkbox") {
        $(idField).prop('checked', false);

        return;
    }

    $(idField).val('');
}

/** @function
 * @name resetSelectField
 * @description Devuelve un input de typo select a un estado inicial (con un option que hace de placeholder)
 * @param {string} idElement id del elemento (incluir el #)
 * @param {string} idForm id del formulario contenedor (incluir el #)
 * @param {boolean} clearContent especifica si se borrara el contenido del select (true / false)
 * @return {void} void
 */
$.Helper.resetSelectField = function (element, clearContent) {
    if (typeof (clearContent) === "boolean" && clearContent) {
        $(element).html('<option></option>');
    }

    $(element).val('').trigger('change');
}


/** @function
 * @name upperCase
 * @description Devuelve un input en mayusculas y mantiene el focus en la posicion indicada
 * @param {string} El value del input
 * @return {void} void
 */

 $.upperCase = function (e) {
    var start = e.selectionStart;
    var end = e.selectionEnd;
    e.value = e.value.toUpperCase();
    e.setSelectionRange(start, end);
 }

 /** @function
 * @name lowerCase
 * @description Devuelve un input en mayusculas y mantiene el focus en la posicion indicada
 * @param {string} El value del input
 * @return {void} void
 */

 $.lowerCase = function (e) {
    var start = e.selectionStart;
    var end = e.selectionEnd;
    e.value = e.value.toLowerCase();
    e.setSelectionRange(start, end);
 }

