<?php 
 ob_start();
    header('Content-Type: text/html; charset=UTF-8');
    //require("fpdf/fpdf.php");
    require("fpdf/pdf_js.php");
    require_once("PDF417/vendor/autoload.php");
    use BigFish\PDF417\PDF417;
    use BigFish\PDF417\Renderers\ImageRenderer;
    include ("letras/NumeroALetras.php");
    include ("config.php");

    /******************************************************************************************/
    /* consultas SQL
    /******************************************************************************************/

    $id = $_GET['id_detalle_credito'];

    $mysqli = new mysqli($db_host,$db_user,$db_pass,$db_name);

    //Para obtener datos de VENTO O PEDIDO

    $query0 = "SELECT d.* , d.created_at as hora, u.username FROM detalle_credito d INNER JOIN usuarios u ON d.id_usuario = u.id_usuario WHERE d.id_detalle_credito = '".$id."' AND d.estado = 1";
    $result0 = $mysqli->query($query0);
    $row0 = $result0->fetch_assoc();

    if (!is_null($row0['id_venta'])) {
        $query1 = "SELECT v.*, v.nombre_comprobante as comprobante, v.fecha_venta as fecha_emision, c.nombre, c.numero_documento, c.direccion, l.direccion as direc, l.telefono as telef FROM ventas v INNER JOIN clientes c ON v.id_cliente = c.id_cliente INNER JOIN local l ON v.id_local = l.id_local  WHERE id_venta = '".$row0['id_venta']."' ";
        $result1 = $mysqli->query($query1);
        $row1 = $result1->fetch_assoc();

        $DeudaInicial = number_format($row1['total_venta'], 2, '.', ''); 
        $Adelanto = 0;

        $query2 = "SELECT *  FROM detalle_credito  WHERE id_venta = '".$row0['id_venta']."' AND estado = 1 AND id_detalle_credito <>'".$id."' ";
        $result2 = $mysqli->query($query2);

        $tipo = "VENTA";


    } else {
        $query1 = "SELECT p.* , p.id_proforma as comprobante, l.direccion as direc, l.telefono as telef  FROM proformas p INNER JOIN local l ON p.id_local = l.id_local WHERE id_proforma = '".$row0['id_proforma']."' ";
        $result1 = $mysqli->query($query1);
        $row1 = $result1->fetch_assoc();

        $DeudaInicial = number_format($row1['total'], 2, '.', ''); 
        $Adelanto = number_format($row1['adelanto'], 2, '.', ''); 

        $query2 = "SELECT *  FROM detalle_credito  WHERE id_proforma= '".$row0['id_proforma']."' AND estado = 1 AND id_detalle_credito <> '".$id."' ";
        $result2 = $mysqli->query($query2);

        $tipo = "PEDIDO";
    }

    

    //Para obtener los datos de la empresa
    $query3 = "SELECT * FROM empresa WHERE id_empresa = '1' ";
    $result3 = $mysqli->query($query3);
    $row3 = $result3->fetch_assoc();


    // Variables correspondientes a la factura.
    $RUC        = $row1['numero_documento'];    // RUC.
    $NomRazSoc  = $row1['nombre'];              // Nombre o Razón social.
    $FecEmi     = $row0['fecha_pago'];         // Fecha de emisión.
    $Domicilio  = $row1['direccion'];           // Domicilio.
    $TotGrav    = 0;                            // Total gravado.
    $TotIGV     = 0;                            // Total IGV.
    $TotMonto   = 0;  
    //$Saldo      = $row1['saldo'];                               
    //$Adelanto   = $row1['adelanto'];                    
    $autoriza   = $row3['autorizacion'];
    $pagina     = $row3['pagina_web'];
    $empresa    = $row3['razon_social'];
   
    // TOTALES DE LA FACTURA 
    
    $sub_total = 0;
    $total = 0;
    $igv = 0;
    $desc = 0;
    $ii=0;
    $Pagado=0;

    
    while($row2 = $result2->fetch_assoc()){

        if ($row2['id_detalle_credito'] < $row0['id_detalle_credito']) {
            $Pagado = $Pagado + $row2['monto'];
        }
        
    }


    $TotMonto = number_format($row0['monto'], 2, '.', '');       
 

    /******************************************************************************************/
    /* creamos documento PDF
    /******************************************************************************************/

    $pdf=new PDF('P','cm','Letter');
    $pdf->AliasNbPages();
    $pdf->AddPage();
    $pdf->AddFont('IDAutomationHC39M','','IDAutomationHC39M.php');
    $pdf->AddFont('verdana','','verdana.php');
    $pdf->SetAutoPageBreak(true);
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetLineWidth(0.02);
    $pdf->SetFillColor(0,0,0);
    $pdf->Footer(true);


    function cargarEncabezado($pdf, $row1,  $row0,$row3, $Domicilio, $pagina) {

    /******************************************************************************************/
    /* ENCABEZADO
    /******************************************************************************************/

        $pdf->image("../public/img/logo_empresa.jpg", 1.2, 1.2 , 4.2, 1.5); // x , y, ancho, alto
        $pdf->RoundedRect(1, 1, 10, 2.5, 0.2, ''); 

        $pdf->SetTextColor(0,0,150);
        $pdf->SetFont('arial','B',10);
        $pdf->SetXY(5.5,1.5);
        $pdf->MultiCell(5.5, 0.4, $row3['razon_social'], 0, "C", 0);

        
        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','',7);
        $pdf->SetXY(1,2.9);
        $pdf->MultiCell(10, 0.3, $row1['direc'], 0,'C', 0);

        $pdf->SetXY(1,3.2);
        $pdf->MultiCell(10, 0.3, ""."Telf: ".$row1['telef'], 0,'C', 0);


        $pdf->RoundedRect(12, 1, 8, 2.5, 0.2, ''); 

        $pdf->SetTextColor(170,0,0);
        $pdf->SetFont('arial','',14);
        $pdf->SetXY(12,1.5);
        $pdf->Cell(8, 0.25, "RUC: ".$row3['ruc']."", 0, 1,'C', 0);

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','B',20);
        $pdf->SetXY(12,2.6);
        $pdf->Cell(8, 0.25, utf8_decode("RECIBO N° ".$row0['id_detalle_credito']) , 0, 1,'C', 0); 

        /******************************************************************************************/
        /* DATOS DEL CLIENTE
        /******************************************************************************************/

        $h_titu = $pdf->GetMultiCellHeight(15.3, 0.15, utf8_decode($row1['nombre']) , $border=null, $align='L'); 
        $h_domi = $pdf->GetMultiCellHeight(15.3, 0.15, utf8_decode($Domicilio) , $border=null, $align='L');  

        $pdf->RoundedRect(1, 4, 19, 3.2+$h_titu+$h_domi, 0.2, ''); 

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','B',10);


        $pdf->SetXY(1.1,4.2);
        $pdf->Cell(1, 0.35, utf8_decode("Cliente                         :"), 0, 1,'L', 0);

        $pdf->SetXY(1.1,5.4+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, utf8_decode("RUC / DNI"), 0, 1,'L', 0);
     

        $pdf->SetXY(1.1,4.8+$h_titu);
        $pdf->Cell(1, 0.35, utf8_decode("Dirección                    :"), 0, 1,'L', 0);

        $pdf->SetXY(1.1,6.0+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, utf8_decode("Fecha de emisión"), 0, 1,'L', 0);

        $pdf->SetXY(1.1,6.6+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, utf8_decode("Moneda"), 0, 1,'L', 0);


        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','',10);

        $pdf->SetXY(5.0,4.2);
        $pdf->MultiCell(15.3, 0.35, $row1['nombre'], 0, 'L', 0);

        $pdf->SetXY(5.0,4.8+$h_titu);
        $pdf->MultiCell(15.3, 0.35, $Domicilio, 0, 'L', 0);

        $pdf->SetXY(4.7,5.4+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, ":  ".utf8_decode($row1['numero_documento']), 0, 1,'L', 0);

        $pdf->SetXY(4.7,6.0+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, ":  ".date_format(date_create($row0['fecha_pago']), 'd-m-Y')."     Hora : ".date("H:i:s", strtotime($row0['hora'])), 0, 1,'L', 0);

        $pdf->SetXY(4.7,6.6+$h_titu+$h_domi);
        $pdf->Cell(1, 0.35, ":  ".utf8_decode("SOL"), 0, 1,'L', 0);


        /******************************************************************************************/
        /* ENCABEZADO DE PRODUCTOS
        /******************************************************************************************/
        
        $Y = $h_titu+$h_domi;

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','B',10);

        $pdf->SetXY(1,$Y+8);
        $pdf->Cell(2.5, 0.5, utf8_decode("Cantidad"), 1, 1,'C', 0);

        $pdf->SetXY(3.5,$Y+8);
        $pdf->Cell(14.0, 0.5, utf8_decode("Descripción"), 1, 1,'C', 0);

        $pdf->SetXY(17.5,$Y+8);
        $pdf->Cell(2.5, 0.5, utf8_decode("Importe"), 1, 1,'C', 0);

        

        /******************************************************************************************/
        /* PIE DE PAGINA
        /******************************************************************************************/

        $pdf->line(1, 25.8, 20.5, 25.8);

        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont('arial','',9);
        $pdf->SetXY(1,26);
        //$pdf->MultiCell(19.5, 0.35, utf8_decode("Comprobante NO VALIDO, reclame su BOLETA o FACTURA \n $pagina \n GRACIAS POR SU PREFERENCIA !!"), 0, 'C'); 
        $pdf->MultiCell(19.5, 0.35, utf8_decode(" $pagina \n GRACIAS POR SU PREFERENCIA !!"), 0, 'C'); 

        return $Y;
    }

    $Y2 = cargarEncabezado($pdf, $row1, $row0, $row3, $Domicilio, $pagina);

    
    /******************************************************************************************/
    /* LISTA  DE PRODUCTOS
    /******************************************************************************************/
    
    $Y = $Y2 + 8.5;
    $Y1 = 0;

    $pdf->SetFont('arial','', 9);
    
    $h_descrip = $pdf->GetMultiCellHeight(8.6, 0.5, utf8_decode("PAGO DE LETRA"), $border=null, $align='L'); 
    
    $pdf->SetXY(1,$Y+$Y1);
    $pdf->Cell(2.5, $h_descrip, utf8_decode("1"), 1, 1,'C', 0);

    $pdf->SetXY(3.5,$Y+$Y1);
    $pdf->MultiCell(14.0, 0.5, "PAGO DE CUOTA DE DEUDA PENDIENTE DE ".$tipo.utf8_decode(" N° "). $row1['comprobante'] , 1, "L", 0);

    $pdf->SetXY(17.5,$Y+$Y1);
    $pdf->Cell(2.5, $h_descrip, number_format($row0['monto'],2), 1, 1,'R', 0);

    $Y1 = $Y1 + $h_descrip;


    $pdf->SetFont('arial','B',12);
    $pdf->SetXY(9.9,$Y1+10);
    $pdf->Cell(7.6, 0.7, utf8_decode("Importe Total        S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,$Y1+10);
    $pdf->Cell(2.5, 0.7, number_format($row0['monto'],2), 1, 1,'R', 0);





    $pdf->SetFont('arial','', 9);

    $pdf->SetXY(9.9,$Y1+10.7);
    $pdf->Cell(7.6, 0.5, utf8_decode("Deuda Inicial      S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,$Y1+10.7);
    $pdf->Cell(2.5, 0.5, number_format($DeudaInicial, 2), 1, 1,'R', 0);  

/*    $pdf->SetXY(9.9,$Y1+11.2);
    $pdf->Cell(7.6, 0.5, utf8_decode("Total de pagos anteriores    S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,$Y1+11.2);
    $pdf->Cell(2.5, 0.5, number_format($Pagado + $Adelanto, 2), 1, 1,'R', 0);  */

    $pdf->SetXY(9.9,$Y1+11.2);
    $pdf->Cell(7.6, 0.5, utf8_decode("Nuevo Saldo      S/ "), 1, 1,'R', 0);

    $pdf->SetXY(17.5,$Y1+11.2);
    $pdf->Cell(2.5, 0.5, number_format($DeudaInicial - ($Pagado + $Adelanto) - $row0['monto'], 2), 1, 1,'R', 0);  



    // nombre de usuario
    $pdf->SetFont('helvetica','BI',8);
    $pdf->SetXY(1,$Y1+11.5);
    $pdf->MultiCell(5, 0.4,"USUARIO : ".$row0['username'] , 0, 'L');

    
    //Monto en letras
    $letras = NumeroALetras::convertir($row0['monto'], 'soles', 'centimos');
    $pdf->SetXY(1,$Y1+12.5);
    $pdf->MultiCell(19, 0.4,"SON : ".$letras ."  SOLES" , 0, 'L');


    //Observacion
    if (!is_null($row0['observacion'])) {
        $pdf->SetFont('helvetica','I',8);
        $pdf->SetXY(1,$Y1+13);
        $pdf->MultiCell(19, 0.4,"OBSERVACION : ".$row0['observacion'] , 0, 'L');
    }
    
    //==============================================================================
    
    $pdf->AutoPrint(true);
    $pdf->Output();
    
ob_end_flush(); 