<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleGuiaRemisionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_guia_remision', function (Blueprint $table) {
            $table->integer('id_detalle_guia_remision')->autoIncrement();
            $table->integer('id_guia_remision')->nullable();
            $table->integer('id_producto')->nullable();
            $table->decimal('cantidad', 9, 2)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_guia_remision')->references('id_guia_remision')->on('guia_remision'); 
            $table->foreign('id_producto')->references('id_producto')->on('productos');   
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_guia_remision');
    }
}
