<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleCreditoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_credito', function (Blueprint $table) {
            $table->integer('id_detalle_credito')->autoIncrement();
            $table->integer('id_usuario')->nullable();
            $table->integer('id_venta')->nullable();
            $table->integer('id_proforma')->nullable();
            $table->date('fecha_pago')->nullable();
            $table->decimal('monto', 9, 2)->nullable();
            $table->string('observacion', 500)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios'); 
            $table->foreign('id_venta')->references('id_venta')->on('ventas');      
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_credito');
    }
}
