<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetalleTrasladoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('detalle_traslado', function (Blueprint $table) {
            $table->integer('id_detalle_traslado')->autoIncrement();
            $table->integer('id_traslado');
            $table->integer('id_producto');
            $table->decimal('cantidad', 9, 2)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_traslado')->references('id_traslado')->on('traslados'); 
            $table->foreign('id_producto')->references('id_producto')->on('productos'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('detalle_traslado');
    }
}
