<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNotasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notas', function (Blueprint $table) {
            $table->integer('id_nota')->autoIncrement();
            $table->integer('id_venta')->nullable();
            $table->integer('id_usuario');
            $table->integer('id_local');
            $table->integer('id_tipo_comprobante'); 
            $table->string('serie_nota', 5);
            $table->integer('numero_nota');
            $table->string('nombre_nota', 20)->nullable();
            $table->date('fecha_emision')->nullable();
            $table->string('id_motivo', 5)->nullable();
            $table->string('motivo', 50)->nullable();
            $table->string('descripcion', 200)->nullable();
            $table->tinyInteger('contingencia')->default('0');
            $table->string('estado_envio', 15)->nullable(); //REGISTRADO, ACEPTADO, NO ENVIADO, RECHAZADO
            $table->string('mensaje_envio', 500)->nullable();
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();
            
            $table->foreign('id_venta')->references('id_venta')->on('ventas'); 
            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios');    
            $table->foreign('id_local')->references('id_local')->on('local');  
            $table->foreign('id_tipo_comprobante')->references('id_tipo_comprobante')->on('tipo_comprobante');  
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notas');
    }
}
