<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Producto extends Model
{
    protected $table = 'productos';
    protected $primaryKey = 'id_producto';

    protected $fillable = [
        'id_producto', 'id_tipo_presentacion', 'id_unidad_medida', 'nombre', 'codigo_barras', 'descripcion', 'precio', 'precio_mayorista', 'precio_compra', 'utilidad', 'tipo_producto', 'fecha_vencimiento', 'lote', 'situacion_impuesto', 'tipo_impuesto', 'valor_impuesto','icbper','url_imagen', 'estado'
    ];

    public function tipo_presentacion()
    {
        return $this->belongsTo('App\Models\TipoPresentacion', 'id_tipo_presentacion');
    }
    public function unidad_medida()
    {
        return $this->belongsTo('App\Models\UnidadMedida', 'id_unidad_medida');
    }
}
