<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Local extends Model
{
    protected $table = 'local';
    protected $primaryKey = 'id_local';
    protected $foreingKey = 'id_tipo_local';

    protected $fillable = [
        'id_local', 'id_tipo_local','nombre', 'direccion', 'telefono', 'serie_factura', 'serie_boleta', 'serie_guia', 'estado'
    ];

    public function tipo_local()
    {
        return $this->belongsTo('App\Models\TipoLocal', 'id_tipo_local');
    }
}
