<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Delivery extends Model
{
    protected $table = 'delivery';
    protected $primaryKey = 'id_delivery';

    protected $fillable = [
        'id_delivery', 'id_local', 'id_usuario', 'nombre', 'numero_documento', 'direccion', 'telefono', 'email', 'latitud', 'longitud', 'fecha_emision', 'total', 'metodo_pago', 'estado_pago', 'observacion', 'estado_delivery', 'estado'
    ];

    public function usuario()
    {
        return $this->belongsTo('App\Models\Usuario', 'id_usuario');
    }
    public function local()
    {
        return $this->belongsTo('App\Models\Local', 'id_local');
    }

}
