<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Traslado;
use App\Models\DetalleTraslado;
use App\Models\Local;
use App\Models\Producto;
use App\Models\Usuario;
use App\Models\ProductoLocal;


class TrasladoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function nuevo()
    {
	 	$data = [
            'locales' => Local::with('tipo_local')->where('estado', 1)->get(),
            'producto' => ProductoLocal::with('producto')->where('id_local', Auth::guard("usuario")->user()->id_local)->where('estado', 1)->where('stock', '>', 0)->limit(50)->get(),
        ];
        return view('traslado.nuevo', $data); 
	}

	public function listar()
	{
		$res = Traslado::with(['local_origen', 'local_destino'])->where('estado', 1)->orderBy('created_at', 'desc')->paginate(20);
        return view('traslado.listar', [ 'data' => $res]); 
	}

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $request->request->add(['id_usuario' => Auth::guard("usuario")->user()->id_usuario]); 
            $res = Traslado::create($request->all());

            if ($res) 
            {
                for( $i = 0; $i < count($request->id_producto); $i++)
                {
                    $detalle= [
                        'id_traslado' => $res->id_traslado, 
                        'id_producto' => $request->id_producto[$i], 
                        'cantidad' => $request->cantidad[$i], 
                    ];

                    $res1 = DetalleTraslado::create($detalle);

                    if ($res1) 
                    {
                        $producto_origen = ProductoLocal::where(['id_producto' => $request->id_producto[$i] , 'id_local' => $request->id_local_origen])->get();
                        $prod1 = ProductoLocal::find($producto_origen[0]->id_producto_local);
                        $prod1->stock = $producto_origen[0]->stock - $request->cantidad[$i];
                        $prod1->save();

                        $producto_destino = ProductoLocal::where(['id_producto' => $request->id_producto[$i] , 'id_local' => $request->id_local_destino])->get();
                        if (count($producto_destino) > 0) { 
                            $prod2 = ProductoLocal::find($producto_destino[0]->id_producto_local);

                            if ($prod2->estado == 0) {
                                $prod2->estado = 1;
                                $prod2->stock = 1000000 + $request->cantidad[$i];
                                $prod2->save();
                            }
                            else  {
                                $prod2->stock = $producto_destino[0]->stock + $request->cantidad[$i];
                                $prod2->save();
                            }
                            
                        }
                        else{
                            ProductoLocal::create([
                                'id_producto' => $request->id_producto[$i], 
                                'id_local' => $request->id_local_destino,
                                'stock' => 1000000 + $request->cantidad[$i],
                            ]);
                        }
                       
                    }
                }
            }  
            
            $res ? $res['message'] = 'success' : $res['message'] = 'error';
            return response()->json($res); 
        }
	}

    public function detalles($id)
    {
        return view('traslado.detalles', [
            'data' => Traslado::with(['local_origen', 'local_destino', 'usuario'])->where(['id_traslado' => $id])->first(),
            'detalles' => DetalleTraslado::with(['producto'])->where(['id_traslado' => $id])->get(),
        ]); 
    }

}
