<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Auth;
use App\Models\Local;
use App\Models\TipoLocal;
use App\Models\Nota;
use App\Models\Venta;

class LocalController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }
    
	public function nuevo()
    {
	 	$data = [
            'tipo_local' => TipoLocal::where('estado', 1)->get(),
            'num' => Local::where(['id_tipo_local' => 1 , 'estado' => 1])->count()+1,
        ];
        return view('local.nuevo', $data); 
	}

	public function listar()
	{
		$res = Local::with(['tipo_local'])->where('estado', 1)->get();
        return view('local.listar', [ 'data' => $res]); 
	}

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            if ($request->id_tipo_local == 1) {
                if (is_null($request->serie_factura)) {
                    $serie_factura = 'F00'.(Local::where(['id_tipo_local' => 1 , 'estado' => 1])->count()+1);
                    $request->merge(['serie_factura' => $serie_factura]);
                }
                if (is_null($request->serie_boleta)) {
                    $serie_boleta ='B00'.(Local::where(['id_tipo_local' => 1 , 'estado' => 1])->count()+1);
                    $request->merge(['serie_boleta' => $serie_boleta]);
                }
                if (is_null($request->serie_guia)) {
                    $serie_guia = 'T00'.(Local::where(['id_tipo_local' => 1 , 'estado' => 1])->count()+1);
                    $request->merge(['serie_guia' => $serie_guia]);
                }
            }

            $res = Local::create($request->all());

            if ($res->id_tipo_local == 1) {
                DB::table('ventas')->insert([
                    ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 1,'serie_comprobante' => $res->serie_factura,'numero_comprobante' => '0'],
                    ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 2,'serie_comprobante' => $res->serie_boleta,'numero_comprobante' => '0'
                    ]
                ]);

                //Guia de remision    
                DB::table('guia_remision')->insert([
                    ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local, 'id_tipo_comprobante' => 5,'serie_guia' => $res->serie_guia,'numero_guia' => '0'
                    ],
                ]);

                //Nota credito y debito
                DB::table('notas')->insert([
                    ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 3,'serie_nota' => $res->serie_factura,'numero_nota' => '0'],
                    ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 3,'serie_nota' => $res->serie_boleta,'numero_nota' => '0'],
                    ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 4,'serie_nota' => $res->serie_factura,'numero_nota' => '0'],
                    ['id_usuario' => Auth::guard("usuario")->user()->id_usuario, 'id_local' => $res->id_local,'id_tipo_comprobante' => 4,'serie_nota' => $res->serie_boleta,'numero_nota' => '0'],
                ]);

            }

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']); 
        }
	}

	public function editar($id)
    {
        return view('local.editar', [
            'data' => Local::where(['id_local' => $id , 'estado' => 1])->first(), 
            'tipo_local' => TipoLocal::all() 
        ]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Local::find($request->id_local);

            $data->nombre             = $request->nombre; 
            $data->direccion          = $request->direccion;
            $data->telefono           = $request->telefono;
            $data->id_tipo_local      = $request->id_tipo_local;
            if (!is_null($request->serie_guia) && !is_null($request->serie_boleta) && !is_null($request->serie_guia)){
                $data->serie_factura      = $request->serie_factura;
                $data->serie_boleta       = $request->serie_boleta;
                $data->serie_guia         = $request->serie_guia;
                if ($request->id_local == 1) {
                    $fac = Venta::find(1);
                    $fac->serie_comprobante = $request->serie_factura;
                    $fac->save();
                    $bol = Venta::find(2);
                    $bol->serie_comprobante = $request->serie_boleta;
                    $bol->save();
                }
            }

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
    	if ($request->ajax())
        {
	      	$data = Local::find($request->id_local);
            $data->estado = 0;
            $res  = $data->save();
	    
	        return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
    	}
    }

    public function getAll(Request $request)
    {
        if ($request->ajax())
        {
            $res = Local::with(['tipo_local'])->where('estado', 1)->get();
            return response()->json($res);  
        }
    }

}
